<title><?php echo e(Auth::user()->name); ?> - money up work</title>

<?php $__env->startSection('css'); ?>
 <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://moneyupwork.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://moneyupwork.com/resources/css/myapp.css" type="text/css">
    <link rel="stylesheet" href="https://moneyupwork.com/resources/css/bttn.css" type="text/css">
    <style>
	.cust_task_working .row {
		border: 1px solid #eaeaea;
		border-radius: 3px;
		padding: 2px;
	}
	.bg-gradient-green {
            background: linear-gradient(87deg,#2dce89 0,#2dcecc 100%)!important;
        }

        .bg-gradient-info {
            background: linear-gradient(87deg,#11cdef 0,#1171ef 100%)!important;
        }
        .icon-shape {
            display: inline-flex;
            /* padding: 12px; */
            text-align: center;
            border-radius: 50%;
            align-items: center;
            justify-content: center;
        }
        .icon {
            width: 3rem;
            height: 3rem;
        }
        .icon-shape i, .icon-shape svg {
            font-size: 1.25rem;
        }
        @media (min-width: 768px) {
            .rounded-circle {
                margin-top: 20px;
                
            }
        }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('user-content'); ?>

<div class="row mt-2">
	<div class="col-xl-4 order-xl-2">
		<div class="card card-profile">
			<img src="https://ibb.co.com/3vmWRkd/g7sFYbP/Whats-App-Image-2024-10-16-at-2-21-37-PM.jpg" alt="Image placeholder" class="card-img-top">
			<div class="row justify-content-center">
				<div class="col-lg-3 order-lg-2">
					<div class="card-profile-image">
						<a href="#">
							<?php if(file_exists(Auth::user()->image)): ?>
                                <img alt="" class="rounded-circle" src="<?php echo e(URL::to(Auth::user()->image)); ?>" width="120px" height="120px">
                            <?php else: ?>
                                <img class="rounded-circle" src="<?php echo e(asset('frontend/img/user.png')); ?>" alt="User Image" width="120px" height="120px">
                            <?php endif; ?>
						</a>
					</div>
				</div>
			</div>
			<div class="card-header text-center border-0 pt-5 pt-md-4 pb-0 pb-md-4"></div>
			<div class="card-body">
				<div class="text-center">
					<h5 class="h2">
						<?php echo e(Auth::user()->name); ?>

						<?php if(Auth::user()->premium_status == 0): ?>
                            <a class="btn btn-sm" style="background-color: transparent; border: 1px solid red; color: red; font-weight: bold; font-size: 6px;">
                                <i class="fas fa-times-circle"></i> Not Verified
                            </a>
                        <?php else: ?>
                            <i class="fas fa-check-circle"></i>
                        <?php endif; ?> 

					</h5>
					<p class="drk-bg-one"><span style='background: #eaeaea;border-radius:5px;padding:2px 5px 2px 5px'><?php echo e(user_work_rating(Auth::user()->id)); ?> Reviews (<?php echo e(user_rating(Auth::user()->id)); ?>) <?php if(user_rating(Auth::user()->id) >= 2.5): ?><i class="fa fa-star checked" style="color:#F37205"></i><?php endif; ?></span></p>
					<?php if(session('user_age')): ?>
					<p class="text-muted">I&#039;m <?php echo e(session('user_age')); ?> years old</p>
					<?php endif; ?>
					<p class="text-muted">Since <?php echo e(\Carbon\Carbon::parse(Auth::user()->created_at)->format('j M, y')); ?></p>
					<?php if(user_activity(Auth::user()->id) == 1): ?>
					<small class="text-muted"><span style='color:#239B56;'> I'm online </span></small>
					<?php else: ?>
					<small class="text-muted"><span style='color:#a2240b;'> I'm offline </span></small>
					<?php endif; ?>
					<div class="h5 font-weight-300">
						<h4>User ID: <?php echo e(Auth::user()->code); ?></h4>	<span class='text'><i class='fas fa-globe'></i> <?php echo e(country(Auth::user()->country)); ?></span> <span class='text'> - <?php echo e(session('user_bio')); ?><?php echo e(Auth::user()->phone); ?></span>
					</div>
					Default
				
					
					 <br>
					<a class="btn btn-primary mt-2 btn-sm bttn" style="border-radius:20px" href="<?php echo e(route('user.manage-profile')); ?>">Manage Profile</a>
				</div>
			</div>
		</div>

<?php
    $approve_ratio = work_approve_ratio(Auth::user()->id);
    $pending_ratio = work_pending_ratio(Auth::user()->id);
    $total_percentage = $approve_ratio + $pending_ratio;
    $total_percentage = min($total_percentage, 100); 
    $work_sutisfied = number_format($total_percentage, 0) . '%';
    $job_sutisfied = number_format(job_approve_ratio(Auth::user()->id), 0) . '%';
?>
		
		<div class="card bg-gradient-green border-0">
			<!-- Card body -->
			<div class="card-body">
				<div class="row">
					<div class="col">
						<h5 class="card-title text-uppercase text-muted mb-0 text-white">WORK RATED</h5>
						<span class="h2 font-weight-bold mb-0 text-white"><?php echo e(total_attend_work(Auth::user()->id)); ?></span>
					</div>
					<div class="col-auto">
						<div class="icon icon-shape bg-white text-dark rounded-circle shadow">
							<i class="fas fa-tasks"></i>
						</div>
					</div>
				</div>
				<p class="mt-3 mb-0 text-sm">
					<span class="text-white mr-2 font-weight-500"><i class="fa fa-percentage"></i> <?php echo e($work_sutisfied); ?></span>
					<span class="text-nowrap text-light font-weight-500">Satisfaction</span>
				</p>
			</div>
		</div>
	    <!--<?php if(total_attend_work(Auth::user()->id) >= 40): ?>
             <div class="alert text-center" id="satisfaction-warning" style="color: red; font-weight: 500; <?php if($work_sutisfied >= 75): ?> display: none; <?php endif; ?>">
            </div>
        <?php endif; ?>-->
       
		<div class="card bg-gradient-info border-0">
			<!-- Card body -->
			<div class="card-body">
				<div class="row">
					<div class="col">
						<h5 class="card-title text-uppercase text-muted mb-0 text-white">JOB</h5>
						<span class="h2 font-weight-bold mb-0 text-white"><?php echo e(user_total_job(Auth::user()->id)); ?></span>
					</div>
					<div class="col-auto">
						<div class="icon icon-shape bg-white text-dark rounded-circle shadow">
							<i class="fas fa-briefcase"></i>
						</div>
					</div>
				</div>
				<p class="mt-3 mb-0 text-sm">
					<span class="text-white mr-2 font-weight-500"><i class="fa fa-percentage"></i> <?php echo e(total_ratio_by_user(Auth::user()->id)); ?>%</span>
					<span class="text-nowrap text-light font-weight-500">Satisfied</span>
				</p>
			</div>
		</div>

	</div>
	<div class="col-xl-8 order-xl-1">

		<div class="row justify-content-center">
			<div class="col-12">

				<div class="card">
					<div class="card-header">
						<h6 class="surtitle">Overview</h6>
						<h5 class="h3 mb-0">Total Working</h5>
					</div>
					<div class="card-body cust_task_working">
						<div class="row mb-2">
							<div class="col-6">Task Attend</div>
							<div class="col-6 text-primary h2"><?php echo e(total_attend_work(Auth::user()->id)); ?></div>
						</div>
						<!--<div class="row mb-2">
							<div class="col-6">Earned</div>
							<div class="col-6">$0</div>
						</div>-->
						<div class="row mb-2">
							<div class="col-6">Satisfied <br> <h6>Approved in task</h6></div>
							
							<div class="col-6 text-success h2"><?php echo e(user_complete_job_approve(Auth::user()->id)); ?></div>
						</div>
						<div class="row mb-2">
							<div class="col-6">Not Satisfied<br><h6>Rejected in task prove</h6></div>
							<div class="col-6 text-danger h2"><?php echo e(user_complete_job_reject(Auth::user()->id)); ?></div>
						</div>
						<div class="row mb-2">
							<div class="col-6">Pending <br><h6>In review for rating</h6></div>
							<div class="col-6 text-info h2"><?php echo e(user_complete_job_pending(Auth::user()->id)); ?></div>
						</div>
						<!--<div class="row mb-2">
							<div class="col-6">Deleted/Removed task <br> <h6></h6></div>
							<div class="col-6 text-danger h2">0</div>
						</div>-->
												<div class="row mb-2">
							<div class="col-6">Payment Received</div>
							<div class="col-6 h3" style="color:#ffad29">$<?php echo e(number_format(count_total_withdraws(Auth::user()->id), 2)); ?></div>
						</div>
												<div class="row mb-2">
							<div class="col-6">Last Task</div>
							<div class="col-6 text-info h3"><?php if(last_worked_job(Auth::user()->id)): ?> <?php echo e(\Carbon\Carbon::parse(last_worked_job(Auth::user()->id)->created_at)->format('j M, y')); ?> <?php endif; ?></div>
						</div>
						
						
					</div>
				</div>

				<div class="card">
					<div class="card-header">
						<h6 class="surtitle">Overview</h6>
						<h5 class="h3 mb-0">Total Job</h5>
					</div>
					<div style="color:#27954f">
						<div class="card-body">
							<div class="row mb-2">
								<div class="col-6">Valid Jobs Posted</div>
								<div class="col-6"><?php echo e(user_total_job(Auth::user()->id)); ?></div>
							</div>
							<div class="row mb-2">
								<div class="col-6">Total Deposit</div>
								<div class="col-6">$<?php echo e(number_format(count_total_deposits(Auth::user()->id), 2)); ?></div>
							</div>
							<div class="row mb-2">
								<div class="col-6">Paid</div>
								<div class="col-6">$<?php echo e(number_format(total_balance_spend(Auth::user()->id), 2)); ?></div>
							</div>
							<div class="row mb-2 text-red">
								<div class="col-6">Job Over</div>
								<div class="col-6"><?php echo e(count_jobs_over(Auth::user()->id)); ?></div>
							</div>
						</div>
					</div>
				</div>
								
			</div>

		</div>
	</div>
</div>


		
            
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="text-center">Working Status</h4>
                    <div class="d-flex justify-content-center">
                        <canvas id="working_status" style="width="320" height="320"></canvas>
                    </div>
                </div>
            </div>
        </div>
    
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="text-center">Job Status</h4>
                    <div class="d-flex justify-content-center">
                        <canvas id="job_status" style="width="320" height="320"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

   
<?php
    $work_sutisfied = work_approve_ratio(Auth::user()->id);
    $work_pending = work_pending_ratio(Auth::user()->id);
    $work_reject = work_reject_ratio(Auth::user()->id);
    
    $job_sutisfied = job_approve_ratio(Auth::user()->id);
    $job_pending = job_pending_ratio(Auth::user()->id);
    $job_reject = job_reject_ratio(Auth::user()->id);
?>

</section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js"></script>
    
    <script>
    var xValues = ["Satisfied", "Unsatisfied", "Pending", "Not Rated"];
    var workValues = [<?php echo e($work_sutisfied); ?>, <?php echo e($work_reject); ?>, <?php echo e($work_pending); ?>];
    var jobValues = [<?php echo e($job_sutisfied); ?>, <?php echo e($job_reject); ?>, <?php echo e($job_pending); ?>];
    var barColors = [
        "#00aba9",
        "#b91d47",
        "#f5c242",
        "#BDC3C7"
    ];

    // Calculate the NotRated value dynamically
    var workNotRated = 100 - (workValues.reduce((acc, val) => acc + val, 0));
    var jobNotRated = 100 - (jobValues.reduce((acc, val) => acc + val, 0));

    workValues.push(workNotRated);
    jobValues.push(jobNotRated);

    new Chart("working_status", {
        type: "doughnut",
        data: {
            labels: xValues,
            datasets: [{
                backgroundColor: barColors,
                data: workValues
            }]
        },
        options: {
            title: {
                display: true
            }
        }
    });

    new Chart("job_status", {
        type: "doughnut",
        data: {
            labels: xValues,
            datasets: [{
                backgroundColor: barColors,
                data: jobValues
            }]
        },
        options: {
            title: {
                display: true
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sakibwe1/microjobtwo.sakibwebtech.website/resources/views/user/pages/profile.blade.php ENDPATH**/ ?>